% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runComBatSeq}
\alias{runComBatSeq}
\title{Apply ComBat-Seq batch effect correction method to SingleCellExperiment
object}
\usage{
runComBatSeq(
  inSCE,
  useAssay = "counts",
  batch = "batch",
  covariates = NULL,
  bioCond = NULL,
  useSVA = FALSE,
  assayName = "ComBatSeq",
  shrink = FALSE,
  shrinkDisp = FALSE,
  nGene = NULL
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Default \code{"counts"}.}

\item{batch}{A single character indicating a field in
\code{\link[SummarizedExperiment]{colData}} that annotates the batches.
Default \code{"batch"}.}

\item{covariates}{A character vector indicating the fields in
\code{\link[SummarizedExperiment]{colData}} that annotates other covariates,
such as the cell types. Default \code{NULL}.}

\item{bioCond}{A single character indicating a field in
\code{\link[SummarizedExperiment]{colData}} that annotates the biological
conditions. Default \code{NULL}.}

\item{useSVA}{A logical scalar. Whether to estimate surrogate variables and
use them as an empirical control. Default \code{FALSE}.}

\item{assayName}{A single characeter. The name for the corrected assay. Will
be saved to \code{\link[SummarizedExperiment]{assay}}. Default
\code{"ComBat"}.}

\item{shrink}{A logical scalar. Whether to apply shrinkage on parameter
estimation. Default \code{FALSE}.}

\item{shrinkDisp}{A logical scalar. Whether to apply shrinkage on dispersion.
Default \code{FALSE}.}

\item{nGene}{An integer. Number of random genes to use in empirical Bayes
estimation, only useful when \code{shrink} is set to \code{TRUE}. Default
\code{NULL}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{assay(inSCE, assayName)} updated.
}
\description{
The ComBat-Seq batch adjustment approach assumes that batch effects represent
non-biological but systematic shifts in the mean or variability of genomic
features for all samples within a processing batch. It uses either parametric
or non-parametric empirical Bayes frameworks for adjusting data for batch
effects.
}
\details{
For the parameters \code{covariates} and \code{useSVA}, when the cell type
information is known, it is recommended to specify the cell type annotation
to the argument \code{covariates}; if the cell types are unknown but
expected to be balanced, it is recommended to run with default settings, yet
informative covariates could still be useful. If the cell types are unknown
and are expected to be unbalanced, it is recommended to set \code{useSVA}
to \code{TRUE}.
}
\examples{
data('sceBatches', package = 'singleCellTK')
sceBatches <- sample(sceBatches, 40)
# Cell type known
sceBatches <- runComBatSeq(sceBatches, "counts", "batch",
                           covariates = "cell_type",
                           assayName = "ComBat_cell_seq")
# Cell type unknown but balanced
#sceBatches <- runComBatSeq(sceBatches, "counts", "batch",
#                           assayName = "ComBat_seq")
# Cell type unknown and unbalanced
#sceBatches <- runComBatSeq(sceBatches, "counts", "batch",
#                           useSVA = TRUE,
#                           assayName = "ComBat_sva_seq")
}
