% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runClusterSummaryMetrics.R
\name{runClusterSummaryMetrics}
\alias{runClusterSummaryMetrics}
\title{Run Cluster Summary Metrics}
\usage{
runClusterSummaryMetrics(
  inSCE,
  useAssay = "logcounts",
  featureNames,
  displayName = NULL,
  groupNames = "cluster",
  scale = FALSE
)
}
\arguments{
\item{inSCE}{The single cell experiment to use.}

\item{useAssay}{The assay to use.}

\item{featureNames}{A string or vector of strings with each gene to aggregate.}

\item{displayName}{A string that is the name of the column used for genes.}

\item{groupNames}{The name of a colData entry that can be used as groupNames.}

\item{scale}{Option to scale the data. Default: \code{FALSE}. Selected assay will not be scaled.}
}
\value{
A dataframe with mean expression and percent of cells in cluster that 
express for each cluster.
}
\description{
Calculates the mean expression of percent of cells that express the
given genes for each cluster
}
\examples{
data("scExample")
runClusterSummaryMetrics(inSCE=sce, useAssay="counts", featureNames=c("B2M", "MALAT1"), 
displayName="feature_name", groupNames="type")
}
