% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runQC.R
\name{runCellQC}
\alias{runCellQC}
\title{Perform comprehensive single cell QC}
\usage{
runCellQC(
  inSCE,
  algorithms = c("QCMetrics", "scDblFinder", "cxds", "bcds", "cxds_bcds_hybrid",
    "decontX", "decontX_bg", "soupX", "soupX_bg"),
  sample = NULL,
  collectionName = NULL,
  geneSetList = NULL,
  geneSetListLocation = "rownames",
  geneSetCollection = NULL,
  mitoRef = "human",
  mitoIDType = "ensembl",
  mitoPrefix = "MT-",
  mitoID = NULL,
  mitoGeneLocation = "rownames",
  useAssay = "counts",
  background = NULL,
  bgAssayName = NULL,
  bgBatch = NULL,
  seed = 12345,
  paramsList = NULL
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object.}

\item{algorithms}{Character vector. Specify which QC algorithms to run.
Available options are "QCMetrics", "scrublet", "doubletFinder", "scDblFinder", 
"cxds", "bcds", "cxds_bcds_hybrid", "decontX" and "soupX".}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
Algorithms will be run on cells from each sample separately.}

\item{collectionName}{Character. Name of a \code{GeneSetCollection} obtained by 
using one of the importGeneSet* functions. Default \code{NULL}.}

\item{geneSetList}{See \code{runPerCellQC}. Default NULL.}

\item{geneSetListLocation}{See \code{runPerCellQC}. Default NULL.}

\item{geneSetCollection}{See \code{runPerCellQC}. Default NULL.}

\item{mitoRef, mitoIDType, mitoPrefix, mitoID, mitoGeneLocation}{Arguments used to 
import mitochondrial genes and quantify their expression. Please see 
\link[singleCellTK]{runPerCellQC} for detailed information.}

\item{useAssay}{A string specifying which assay contains the count
matrix for cells.}

\item{background}{A \link[SingleCellExperiment]{SingleCellExperiment}
with the matrix located in the assay slot under \code{bgAssayName}. It should have 
the same structure as inSCE except it contains the matrix of empty droplets instead 
of cells. When supplied, empirical distribution of transcripts from these 
empty droplets will be used as the contamination distribution. It is only used in 
algorithms "decontX" and "soupX". Default NULL.}

\item{bgAssayName}{Character. Name of the assay to use if background is a 
\link[SingleCellExperiment]{SingleCellExperiment}. If NULL, the function
will use the same value as \code{useAssay}. It is only used in algorithms 
"decontX" and "soupX". Default is NULL.}

\item{bgBatch}{Batch labels for \code{background}. If \code{background} is a 
\link[SingleCellExperiment]{SingleCellExperiment} object, this can be a single 
character specifying a name that can be found in \code{colData(background)} 
to directly use the barcode annotation Its unique values should be the same
as those in \code{sample}, such that each batch of cells have their corresponding 
batch of empty droplets as background, pointed by this parameter. It is only used in
algorithms "decontX" and "soupX". Default to NULL.}

\item{seed}{Seed for the random number generator. Default 12345.}

\item{paramsList}{A list containing parameters for QC functions. Default NULL.}
}
\value{
SingleCellExperiment object containing the outputs of the
 specified algorithms in the \link{colData}
of \code{inSCE}.
}
\description{
A wrapper function to run several QC algorithms on a
 SingleCellExperiment
 object containing cells after empty droplets have been removed.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
\dontrun{
sce <- runCellQC(sce)
}
}
