% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlReports.R
\name{reportQCTool}
\alias{reportQCTool}
\title{Get .html report of the output of the selected QC algorithm}
\usage{
reportQCTool(
  inSCE,
  algorithm = c("BarcodeRankDrops", "EmptyDrops", "QCMetrics", "Scrublet", "ScDblFinder",
    "Cxds", "Bcds", "CxdsBcdsHybrid", "DoubletFinder", "DecontX", "SoupX"),
  output_file = NULL,
  output_dir = NULL
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
the count matrix (full droplets or filtered matrix, depends on the selected QC algorithm) with the output from at least one of these functions:
runQCMetrics, runScrublet, runScDblFinder, runCxds, runBcds, runCxdsBcdsHybrid, runDecontX, runBarcodeRankDrops, runEmptyDrops}

\item{algorithm}{Character. Specifies which QC algorithm report to generate.
Available options are "BarcodeRankDrops", "EmptyDrops", "QCMetrics", "Scrublet", "ScDblFinder", "Cxds", "Bcds", "CxdsBcdsHybrid", "DoubletFinder", "DecontX" and "SoupX".}

\item{output_file}{name of the generated file. If NULL/default then the output file name will be based on the name of the selected QC algorithm name .}

\item{output_dir}{name of the output directory to save the rendered file. If NULL/default the file is stored to the current working directory}
}
\value{
.html file
}
\description{
A  function to generate .html Rmarkdown report for the specified QC algorithm output
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
\dontrun{
sce <- runDecontX(sce)
sce <- runQuickUMAP(sce)
reportQCTool(inSCE = sce, algorithm = "DecontX")
}
}
