% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyPCAVariance}
\alias{plotScanpyPCAVariance}
\title{plotScanpyPCAVariance}
\usage{
plotScanpyPCAVariance(inSCE, nPCs = 50, log = FALSE)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{nPCs}{Number of PCs to show. Default \code{50}.}

\item{log}{Plot on logarithmic scale. Default \code{FALSE}}
}
\value{
plot object
}
\description{
plotScanpyPCAVariance
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
plotScanpyPCAVariance(sce)
}
}
