% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyMarkerGenesHeatmap}
\alias{plotScanpyMarkerGenesHeatmap}
\title{plotScanpyMarkerGenesHeatmap}
\usage{
plotScanpyMarkerGenesHeatmap(
  inSCE,
  groups = NULL,
  groupBy,
  nGenes = 10,
  features = NULL,
  log2fcThreshold = NULL
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{groups}{The groups for which to show the gene ranking. Default \code{NULL}
means that all groups will be considered.}

\item{groupBy}{The key of the observation grouping to consider. By default, 
the groupby is chosen from the rank genes groups parameter.}

\item{nGenes}{Number of genes to show. Default \code{10}}

\item{features}{Genes to plot. Sometimes is useful to pass a specific list of
var names (e.g. genes). The var_names could be a dictionary or a list.}

\item{log2fcThreshold}{Only output DEGs with the absolute values of log2FC
larger than this value. Default \code{NULL}.}
}
\value{
plot object
}
\description{
plotScanpyMarkerGenesHeatmap
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyFindMarkers(sce, colDataName = "Scanpy_louvain_1" )
plotScanpyMarkerGenesHeatmap(sce, groupBy = 'Scanpy_louvain_1')
}
}
