% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSCEHeatmap.R
\name{plotSCEHeatmap}
\alias{plotSCEHeatmap}
\title{Plot heatmap of using data stored in SingleCellExperiment Object}
\usage{
plotSCEHeatmap(
  inSCE,
  useAssay = "logcounts",
  useReducedDim = NULL,
  doLog = FALSE,
  featureIndex = NULL,
  cellIndex = NULL,
  scale = TRUE,
  trim = c(-2, 2),
  featureIndexBy = "rownames",
  cellIndexBy = "rownames",
  cluster_columns = FALSE,
  cluster_rows = FALSE,
  rowDataName = NULL,
  colDataName = NULL,
  aggregateRow = NULL,
  aggregateCol = NULL,
  featureAnnotations = NULL,
  cellAnnotations = NULL,
  featureAnnotationColor = NULL,
  cellAnnotationColor = NULL,
  palette = c("ggplot", "celda", "random"),
  heatmapPalette = c("sequential", "diverging"),
  addCellSummary = NULL,
  rowSplitBy = NULL,
  colSplitBy = NULL,
  rowLabel = FALSE,
  colLabel = FALSE,
  rowLabelSize = 6,
  colLabelSize = 6,
  rowDend = TRUE,
  colDend = TRUE,
  title = NULL,
  rowTitle = "Features",
  colTitle = "Cells",
  rowGap = grid::unit(0, "mm"),
  colGap = grid::unit(0, "mm"),
  border = FALSE,
  colorScheme = NULL,
  ...
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{useAssay}{character. A string indicating the assay name that
provides the expression level to plot. Only for \code{plotSCEHeatmap}.}

\item{useReducedDim}{character. A string indicating the reducedDim name that
provides the expression level to plot. Only for \code{plotSCEDimReduceHeatmap}.}

\item{doLog}{Logical scalar. Whether to do \code{log(assay + 1)}
transformation on the assay indicated by \code{useAssay}. Default
\code{FALSE}.}

\item{featureIndex}{A vector that can subset the input SCE object by rows
(features). Alternatively, it can be a vector identifying features in
another feature list indicated by \code{featureIndexBy}. Default \code{NULL}.}

\item{cellIndex}{A vector that can subset the input SCE object by columns
(cells). Alternatively, it can be a vector identifying cells in another
cell list indicated by \code{featureIndexBy}. Default \code{NULL}.}

\item{scale}{Whether to perform z-score or min-max scaling on each row.Choose from \code{"zscore"}, \code{"min-max"} or default
\code{TRUE} or \code{FALSE}}

\item{trim}{A 2-element numeric vector. Values outside of this range will be
trimmed to their nearst bound. Default \code{c(-2, 2)}}

\item{featureIndexBy}{A single character specifying a column name of
\code{rowData(inSCE)}, or a vector of the same length as \code{nrow(inSCE)},
where we search for the non-rowname feature indices. Not applicable for
\code{plotSCEDimReduceHeatmap}. Default \code{"rownames"}.}

\item{cellIndexBy}{A single character specifying a column name of
\code{colData(inSCE)}, or a vector of the same length as \code{ncol(inSCE)},
where we search for the non-rowname cell indices. Default \code{"rownames"}.}

\item{cluster_columns}{A logical scalar that turns on/off 
clustering of columns. Default \code{FALSE}. Clustering columns should be turned off when using reduced dim 
for plotting as it will be sorted by PCs}

\item{cluster_rows}{A logical scalar that turns on/off clustering of rows. 
Default \code{FALSE}.}

\item{rowDataName}{character. The column name(s) in \code{rowData} that need
to be added to the annotation. Not applicable for
\code{plotSCEDimReduceHeatmap}. Default \code{NULL}.}

\item{colDataName}{character. The column name(s) in \code{colData} that need
to be added to the annotation. Default \code{NULL}.}

\item{aggregateRow}{Feature variable for aggregating the heatmap by row. Can
be a vector or a \code{rowData} column name for feature variable. Multiple
variables are allowed. Default \code{NULL}.}

\item{aggregateCol}{Cell variable for aggregating the heatmap by column. Can
be a vector or a \code{colData} column name for cell variable. Multiple
variables are allowed. Default \code{NULL}.}

\item{featureAnnotations}{\code{data.frame}, with \code{rownames} containing
all the features going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{cellAnnotations}{\code{data.frame}, with \code{rownames} containing
all the cells going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{featureAnnotationColor}{A named list. Customized color settings for
feature labeling. Should match the entries in the \code{featureAnnotations}
or \code{rowDataName}. For each entry, there should be a list/vector of
colors named with categories. Default \code{NULL}.}

\item{cellAnnotationColor}{A named list. Customized color settings for
cell labeling. Should match the entries in the \code{cellAnnotations} or
\code{colDataName}. For each entry, there should be a list/vector of colors
named with categories. Default \code{NULL}.}

\item{palette}{Choose from \code{"ggplot"}, \code{"celda"} or \code{"random"}
to generate unique category colors.}

\item{heatmapPalette}{Choose from \code{"sequential"}, \code{"diverging"} or supply custom palette with colorScheme
to generate unique category colors. Default is \code{"sequential"}}

\item{addCellSummary}{Add summary barplots to column annotation. Supply the name of the column in colData as a character. This option will add summary for categorical variables 
as stacked barplots.}

\item{rowSplitBy}{character. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{rowDataName} or
\code{names(featureAnnotations)}. Default \code{NULL}.}

\item{colSplitBy}{character. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{colDataName} or
\code{names(cellAnnotations)}. Default \code{NULL}.}

\item{rowLabel}{Use a logical for whether to display all the feature names,
a single character to display a column of \code{rowData(inSCE)} annotation,
a vector of the same length as full/subset \code{nrow(inSCE)} to display
customized info. Default \code{FALSE}.}

\item{colLabel}{Use a logical for whether to display all the cell names, a
single character to display a column of \code{colData(inSCE)} annotation,
a vector of the same length as full/subset \code{ncol(inSCE)} to display
customized info. Default \code{FALSE}.}

\item{rowLabelSize}{A number for the font size of feature names. Default
\code{8}}

\item{colLabelSize}{A number for the font size of cell names. Default
\code{8}}

\item{rowDend}{Whether to display row dendrogram. Default \code{TRUE}.}

\item{colDend}{Whether to display column dendrogram. Default \code{TRUE}.}

\item{title}{The main title of the whole plot. Default \code{NULL}.}

\item{rowTitle}{The subtitle for the rows. Default \code{"Genes"}.}

\item{colTitle}{The subtitle for the columns. Default \code{"Cells"}.}

\item{rowGap}{A numeric value or a \code{\link[grid]{unit}} object. For the
gap size between rows of the splitted heatmap. Default
\code{grid::unit(0, 'mm')}.}

\item{colGap}{A numeric value or a \code{\link[grid]{unit}} object. For the
gap size between columns of the splitted heatmap. Default
\code{grid::unit(0, 'mm')}.}

\item{border}{A logical scalar. Whether to show the border of the heatmap or
splitted heatmaps. Default \code{TRUE}.}

\item{colorScheme}{function. A function that generates color code by giving
a value. Can be generated by \code{\link[circlize]{colorRamp2}}.
Default \code{NULL}.}

\item{...}{Other arguments passed to \code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot heatmap of using data stored in SingleCellExperiment Object
}
\examples{
data(scExample, package = "singleCellTK")
plotSCEHeatmap(sce[1:3,1:3], useAssay = "counts")
}
\author{
Yichen Wang
}
