% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importDropEst.R
\name{importDropEst}
\alias{importDropEst}
\title{Create a SingleCellExperiment Object from DropEst output}
\usage{
importDropEst(
  sampleDirs = NULL,
  dataType = c("filtered", "raw"),
  rdsFileName = "cell.counts",
  sampleNames = NULL,
  delayedArray = FALSE,
  class = c("Matrix", "matrix"),
  rowNamesDedup = TRUE
)
}
\arguments{
\item{sampleDirs}{A path to the directory containing the data files. Default "./".}

\item{dataType}{can be "filtered" or "raw". Default \code{"filtered"}.}

\item{rdsFileName}{File name prefix of the DropEst RDS output. default is "cell.counts"}

\item{sampleNames}{A User-defined sample name. This will be prepended to all cell barcode IDs.
Default "sample".}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{FALSE}.}

\item{class}{Character. The class of the expression matrix stored in the SCE
object. Can be one of "Matrix" (as returned by
\link{readMM} function), or "matrix" (as returned by
\link[base]{matrix} function). Default \code{"Matrix"}.}

\item{rowNamesDedup}{Boolean. Whether to deduplicate rownames. Default 
\code{TRUE}.}
}
\value{
A \code{SingleCellExperiment} object containing the count matrix,
 the feature annotations from DropEst as ColData, and any metadata from DropEst
}
\description{
imports the RDS file created by DropEst (https://github.com/hms-dbmi/dropEst) and
create a SingleCellExperiment object from either the raw or filtered counts matrix.
Additionally parse through the RDS to obtain appropriate feature annotations as
SCE coldata, in addition to any metadata.
}
\details{
\code{importDropEst} expects either raw counts matrix stored as "cm_raw" or filtered
counts matrix stored as "cm" in the DropEst rds output.
ColData is obtained from the DropEst corresponding to "mean_reads_per_umi","aligned_reads_per_cell",
"aligned_umis_per_cell","requested_umis_per_cb","requested_reads_per_cb"
If using filtered counts matrix, the colData dataframe is
subset to contain features from the filtered counts matrix alone.
If any annotations of ("saturation_info","merge_targets","reads_per_umi_per_cell") are
found in the DropEst rds, they will be added to the SCE metadata field
}
\examples{
# Example results were generated as per instructions from the developers of dropEst described in
# https://github.com/hms-dbmi/dropEst/blob/master/examples/EXAMPLES.md
sce <- importDropEst(sampleDirs = system.file("extdata/dropEst_scg71", package = "singleCellTK"),
                     sampleNames = 'scg71')
}
