% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkQCUtils.R
\name{generateHTANMeta}
\alias{generateHTANMeta}
\title{Generate HTAN manifest file for droplet and cell count data}
\usage{
generateHTANMeta(
  dropletSCE = NULL,
  cellSCE = NULL,
  samplename,
  htan_biospecimen_id,
  dir,
  dataType = c("Droplet", "Cell", "Both")
)
}
\arguments{
\item{dropletSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
droplet count matrix data}

\item{cellSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
cell count matrix data}

\item{samplename}{The sample name of the \link[SingleCellExperiment]{SingleCellExperiment} objects}

\item{htan_biospecimen_id}{The HTAN biospecimen id of the sample in \link[SingleCellExperiment]{SingleCellExperiment} object}

\item{dir}{The output directory of the SCTK QC pipeline.}

\item{dataType}{Type of the input data. It can be one of "Droplet", "Cell" or "Both".}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object which combines all
objects in sceList. The colData is merged.
}
\description{
Generate HTAN manifest file for droplet and cell count data
}
