% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht_clusters.R
\name{ht_clusters}
\alias{ht_clusters}
\title{Visualize the similarity matrix and the clustering}
\usage{
ht_clusters(
  mat,
  cl,
  dend = NULL,
  col = c("white", "red"),
  draw_word_cloud = TRUE,
  min_term = round(nrow(mat) * 0.01),
  order_by_size = FALSE,
  stat = "pvalue",
  min_stat = ifelse(stat == "count", 5, 0.05),
  exclude_words = character(0),
  max_words = 10,
  word_cloud_grob_param = list(),
  fontsize_range = c(4, 16),
  bg_gp = gpar(fill = "#DDDDDD", col = "#AAAAAA"),
  column_title = NULL,
  ht_list = NULL,
  use_raster = TRUE,
  run_draw = TRUE,
  ...
)
}
\arguments{
\item{mat}{A similarity matrix.}

\item{cl}{Cluster labels inferred from the similarity matrix, e.g. from \code{\link[=cluster_terms]{cluster_terms()}} or \code{\link[=binary_cut]{binary_cut()}}.}

\item{dend}{Used internally.}

\item{col}{A vector of colors that map from 0 to the 97.5^th percentile of the similarity values. The value can also be a color mapping function
generated by \code{\link[circlize:colorRamp2]{circlize::colorRamp2()}}.}

\item{draw_word_cloud}{Whether to draw the word clouds.}

\item{min_term}{Minimal number of functional terms in a cluster. All the clusters
with size less than \code{min_term} are all merged into one separated cluster in the heatmap.}

\item{order_by_size}{Whether to reorder clusters by their sizes. The cluster
that is merged from small clusters (size < \code{min_term}) is always put to the bottom of the heatmap.}

\item{stat}{Type of value for mapping to the font size of keywords in the word clouds. There are two options:
"count": simply number of keywords; "pvalue": enrichment on keywords is performed (by fisher's exact test) and -log10(pvalue) is used to map to font sizes.}

\item{min_stat}{Minimal value for \code{stat} for selecting keywords.}

\item{exclude_words}{Words that are excluded in the word cloud.}

\item{max_words}{Maximal number of words visualized in the word cloud.}

\item{word_cloud_grob_param}{A list of graphic parameters passed to \code{\link[=word_cloud_grob]{word_cloud_grob()}}.}

\item{fontsize_range}{The range of the font size. The value should be a numeric vector with length two.
The font size interpolation is linear.}

\item{bg_gp}{Graphics parameters for controlling word cloud annotation background.}

\item{column_title}{Column title for the heatmap.}

\item{ht_list}{A list of additional heatmaps added to the left of the similarity heatmap.}

\item{use_raster}{Whether to write the heatmap as a raster image.}

\item{run_draw}{Internally used.}

\item{...}{Other arguments passed to \code{\link[ComplexHeatmap:draw-HeatmapList-method]{ComplexHeatmap::draw,HeatmapList-method}}.}
}
\value{
A \code{\link[ComplexHeatmap:HeatmapList-class]{ComplexHeatmap::HeatmapList}} object.
}
\description{
Visualize the similarity matrix and the clustering
}
\examples{
\donttest{
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds",
    package = "simplifyEnrichment"))
cl = binary_cut(mat)
ht_clusters(mat, cl, word_cloud_grob_param = list(max_width = 80))
ht_clusters(mat, cl, word_cloud_grob_param = list(max_width = 80),
    order_by_size = TRUE)
}
}
