% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_methods.R
\name{cmp_make_clusters}
\alias{cmp_make_clusters}
\alias{cmp_make_plot}
\alias{compare_clustering_methods}
\title{Compare clustering methods}
\usage{
cmp_make_clusters(
  mat,
  method = setdiff(all_clustering_methods(), "mclust"),
  verbose = TRUE
)

cmp_make_plot(mat, clt, plot_type = c("mixed", "heatmap"), nrow = 3)

compare_clustering_methods(
  mat,
  method = setdiff(all_clustering_methods(), "mclust"),
  plot_type = c("mixed", "heatmap"),
  nrow = 3,
  verbose = TRUE
)
}
\arguments{
\item{mat}{The similarity matrix.}

\item{method}{Which methods to compare. All available methods are in \code{\link[=all_clustering_methods]{all_clustering_methods()}}.
A value of \code{"all"} takes all available methods. By default "mclust" is excluded because its long runtime.}

\item{verbose}{Whether to print messages.

Ddetails
The function compares following default clustering methods by default:

-\code{kmeans} see \code{cluster_by_kmeans}.
-\code{pam} see \code{cluster_by_pam}.
-\code{dynamicTreeCut} see \code{cluster_by_dynamicTreeCut}.
-\code{mclust} see \code{cluster_by_mclust}. By default it is not included.
-\code{apcluster} see \code{cluster_by_apcluster}.
-\code{hdbscan} see \code{cluster_by_hdbscan}.
-\code{fast_greedy} see \code{cluster_by_fast_greedy}.
-\code{louvain} see \code{cluster_by_louvain}.
-\code{walktrap} see \code{cluster_by_walktrap}.
-\code{MCL} see \code{cluster_by_MCL}.
-\code{binary_cut} see \code{binary_cut}.

Also the user-defined methods in \code{all_clustering_methods} are also compared.}

\item{clt}{A list of clusterings from \code{cmp_make_clusters()}.}

\item{plot_type}{What type of plots to make. See \strong{Details}.}

\item{nrow}{Number of rows of the layout when \code{plot_type} is set to \code{"heatmap"}.}
}
\value{
\code{cmp_make_clusters()} returns a list of cluster label vectors from different clustering methods.

\code{cmp_make_plot()} returns no value.

\code{compare_clustering_methods()} returns no value.
}
\description{
Compare clustering methods
}
\details{
For \code{cmp_make_plot()}, if \code{plot_type} is the default value \code{"mixed"}, a figure with three panels will be generated:
\itemize{
\item A heatmap of the similarity matrix with different classifications as row annotations.
\item A heatmap of the pair-wise concordance of the classifications of every two clustering methods.
\item Barplots of the difference scores for each method (calculated by \code{difference_score}), the number
of clusters (total clusters and the clusters with size >= 5) and the mean similarity of the terms
that are in the same clusters.
}

If \code{plot_type} is \code{"heatmap"}. There are heatmaps for the similarity matrix under clusterings
from different methods. The last panel is a table with the number of clusters under different
clusterings.

\code{compare_clustering_methods()} is basically a wrapper function of \code{cmp_make_clusters()} and \code{cmp_make_plot()}.
}
\examples{
\donttest{
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds",
    package = "simplifyEnrichment"))
compare_clustering_methods(mat)
compare_clustering_methods(mat, plot_type = "heatmap")
}
}
