% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\docType{class}
\name{ontology_DAG-class}
\alias{ontology_DAG-class}
\alias{ontology_DAG}
\title{The ontology_DAG class}
\value{
An \code{ontology_DAG} object.
}
\description{
This class defines the DAG structure of an ontology.
}
\section{Slots}{

\describe{
\item{\code{terms}}{A character vector of length \code{n} of all term names. Other slots that store term-level information use the integer indices of terms.}

\item{\code{n_terms}}{An integer scalar of the total number of terms in the DAG.}

\item{\code{n_relations}}{An integer scalar of the total number of relations in the DAG.}

\item{\code{lt_parents}}{A list of length \code{n}. Each element in the list is an integer index vector of the parent terms of the i^th term.}

\item{\code{lt_children}}{A list of length \code{n}. Each element in the list is an integer index vector of the child terms of the i^th term.}

\item{\code{lt_children_relations}}{A list of length \code{n}. Each element is a vector of the semantic relations between the i^th term and its child terms, e.g. a child "is_a" parent.
The relations are represented as integers. The character name of the relations is in \code{attr(dag@lt_children_relations, "levels")}.}

\item{\code{relations_DAG}}{A simple \code{ontology_DAG} object but constructed for relation types.}

\item{\code{source}}{The source of the ontology. A character scalar only used as a mark of the returned object.}

\item{\code{root}}{An integer scalar of the root term.}

\item{\code{leaves}}{An integer vector of the indicies of leaf terms.}

\item{\code{alternative_terms}}{A named character vector of mappings between alternative terms to DAG terms.}

\item{\code{tpl_sorted}}{An integer vector of reordered term indices which has been topologically sorted in the DAG. Terms are sorted first by the depth (maximal
distance from root), then the number of child terms, then the number of parent terms, and last the term names.}

\item{\code{tpl_pos}}{The position of the original term in the topologically sorted path (similar as the rank), e.g. the value of the first element in the vector
is the position of term 1 in the topologically sorted path.}

\item{\code{annotation}}{A list of two elements: \code{list} and \code{names}. The \code{dag@annotation$list} element contains a list of length \code{n} and each element
is a vector of integer indices of annotated items. The full list of annotated items is in \code{dag@annotation$names}.}

\item{\code{term_env}}{An environment which contains various term-level statistics. It is mainly for cache purpose.}

\item{\code{aspect_ratio}}{A numeric vector of length two. The aspect ratio is calculated as \code{w/h}. For each term, there is a distance to root,
\code{h} is the maximal distance of all terms, \code{w} is the maximal number of items with the same distance. The two values in the \code{aspect_ratio} slot
use maximal distance to root (the height) and the shortest distance to root as the distance measure.}

\item{\code{elementMetadata}}{An additional data frame with the same number of rows as the number of terms in DAG. Order of rows should be the same as order of terms in \code{dag@terms}.}
}}

\examples{
1
# This function should not be used directly.
}
