% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transverse.R
\name{n_offspring}
\alias{n_offspring}
\alias{n_ancestors}
\alias{n_connected_leaves}
\alias{n_parents}
\alias{n_children}
\alias{avg_parents}
\alias{avg_children}
\title{Number of parent/child/ancestor/offspring/leaf terms}
\usage{
n_offspring(dag, terms = NULL, use_cache = TRUE, include_self = FALSE)

n_ancestors(dag, terms = NULL, use_cache = TRUE, include_self = FALSE)

n_connected_leaves(dag, terms = NULL, use_cache = TRUE)

n_parents(dag, terms = NULL)

n_children(dag, terms = NULL)

avg_parents(dag)

avg_children(dag)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names. If the value is \code{NULL}, it returns for all terms in the DAG.}

\item{use_cache}{Internally used.}

\item{include_self}{For \code{n_offspring()} and \code{n_ancestors()}, this controls whether to also include the query term itself.}
}
\value{
An integer vector.
}
\description{
Number of parent/child/ancestor/offspring/leaf terms
}
\details{
For \code{n_connected_leaves()}, leaf nodes have value of 1.

In \code{avg_parents()}, root term is removed.

In \code{avg_children()}, leaf term is removed.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
n_parents(dag)
n_children(dag)
n_offspring(dag)
n_ancestors(dag)
n_connected_leaves(dag)
}
