% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_obo}
\alias{import_obo}
\alias{import_owl}
\alias{import_ontology}
\alias{import_ttl}
\title{Import ontology file to an ontology_DAG object}
\usage{
import_obo(
  file,
  relation_type = character(0),
  inherit_relations = TRUE,
  verbose = simona_opt$verbose,
  ...
)

import_owl(
  file,
  relation_type = character(0),
  inherit_relations = TRUE,
  verbose = simona_opt$verbose,
  ...
)

import_ontology(
  file,
  robot_jar = simona_opt$robot_jar,
  JAVA_ARGS = "",
  verbose = simona_opt$verbose,
  ...
)

import_ttl(file, relation_type = "part_of", verbose = simona_opt$verbose, ...)
}
\arguments{
\item{file}{Path of the ontology file or an URL.}

\item{relation_type}{Semantic relation types to include. Note \code{is_a} relation is always included.}

\item{inherit_relations}{Relations may also be structured as a DAG. It controls whether to merge with a relations's offspring relations.}

\item{verbose}{Whether to print messages.}

\item{...}{Pass to \code{\link[=create_ontology_DAG]{create_ontology_DAG()}}.}

\item{robot_jar}{The path of the \code{robot.jar} file. It can be downloaded from https://github.com/ontodev/robot/releases.
Internally, the file is converted to the obo format and parsed by \code{import_obo()}. The value of \code{robot_jar} can be
set as a global option \code{simona_opt$robot_jar = ...}.}

\item{JAVA_ARGS}{Options for \code{java}. For example you can set \code{-Xmx20G} if you want to increase the memory to 20G for java.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Import ontology file to an ontology_DAG object
}
\details{
Public bio-ontologies can be obtained from \href{http://obofoundry.org/}{Ontology Foundry} or \href{https://bioportal.bioontology.org/}{BioPortal}.

The \code{import_obo()} function parses the ontology file in \code{.obo} format. To parse other formats, external tool \code{robot.jar} is required.

\code{import_owl()} only recognizes \verb{<owl:Class>} and \verb{<owl:ObjectProperty>}. If the .owl file does not contain these tags,
please use \code{import_ontology()} directly.

\code{robot.jar} can automatically recognize the following formats:
\itemize{
\item \code{json}: OBO Graphs JSON
\item \code{obo}: OBO Format
\item \code{ofn}: OWL Functional
\item \code{omn}: Manchester
\item \code{owl}: RDF/XML
\item \code{owx}: OWL/XML
\item \code{ttl}: Turtle
}

The description of the ROBOT tool is at \url{http://robot.obolibrary.org/convert}.

\code{import_ttl()} is a simple parser for the \code{.ttl} format files. It only recognizes
terms that have the \code{owl:Class} object. The "is_a" relation is recognized by the predicate \code{rdfs:subClassOf}
or an ontology-specific predicate that contains \verb{.*/isa}. Other relation types are defined with
the predicate \code{owl:ObjectProperty}. The format is parsed by a Perl script \code{system.file("scripts", "parse_ttl.pl", package = "simona")}.
}
\examples{
\donttest{
# The plant ontology: http://obofoundry.org/ontology/po.html 
import_obo("https://raw.githubusercontent.com/Planteome/plant-ontology/master/po.obo")
}
\donttest{
import_owl("http://purl.obolibrary.org/obo/po.owl") 
}
\dontrun{
# The plant ontology: http://obofoundry.org/ontology/po.html 
dag = import_ontology("http://purl.obolibrary.org/obo/po.owl", robot_jar = ...)
}
\donttest{
# file is from https://bioportal.bioontology.org/ontologies/MSTDE
import_ttl("https://jokergoo.github.io/simona/MSTDE.ttl")
}
}
