% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{dag_treelize}
\alias{dag_treelize}
\alias{dag_as_dendrogram}
\alias{print.ontology_tree}
\title{Reduce the DAG to a tree}
\usage{
dag_treelize(dag, verbose = simona_opt$verbose)

dag_as_dendrogram(dag)

\method{print}{ontology_tree}(x, ...)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{verbose}{Whether to print messages.}

\item{x}{An \code{ontology_DAG} object.}

\item{...}{Ignored.}
}
\value{
A tree is also an \code{ontology_DAG} object.
}
\description{
Reduce the DAG to a tree
}
\details{
A tree is a reduced DAG where a child only has one parent. The reducing is applied by a breadth-first searching

Starting from the root and on a certain depth (the depth is the maximal distance to root), for every term \code{t} on this depth,
its child term \code{c} and parent-child relation are kept only when \code{depth(c) == depth(t) + 1}. If \code{c} is selected, it is
marked as visited and will not be checked again.

In this way, depths of all terms in the orignal DAG are still identical to the depths in the tree (see the Examples section).

\code{dag_as_dendrogram()} coverts the tree to a \code{dendrogram} object.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
tree = dag_treelize(dag)
d1 = dag_depth(dag)
d2 = dag_depth(tree)
identical(d1, d2)

dend = dag_as_dendrogram(tree)
dend
}
