% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{dag_root}
\alias{dag_root}
\alias{dag_leaves}
\alias{dag_is_leaf}
\title{Root or leaves of the DAG}
\usage{
dag_root(dag, in_labels = TRUE)

dag_leaves(dag, in_labels = TRUE)

dag_is_leaf(dag, terms)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{in_labels}{Whether the terms are represented in their names or as integer indices?}

\item{terms}{A vector of term names.}
}
\value{
A character or an integer vector.
}
\description{
Root or leaves of the DAG
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
dag_root(dag)
dag_leaves(dag)
}
