% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{dag_random_tree}
\alias{dag_random_tree}
\alias{dag_add_random_children}
\alias{dag_random}
\title{Generate a random DAG}
\usage{
dag_random_tree(
  n_children = 2,
  p_stop = 0,
  max = 2^10 - 1,
  verbose = simona_opt$verbose
)

dag_add_random_children(
  dag,
  p_add = 0.1,
  new_children = c(1, 4),
  add_random_children_fun = NULL,
  verbose = simona_opt$verbose
)

dag_random(
  n_children = 2,
  p_stop = 0,
  max = 2^10 - 1,
  p_add = 0.1,
  new_children = c(1, 4),
  verbose = simona_opt$verbose
)
}
\arguments{
\item{n_children}{Number of children of a term. The value can also be a vector of
length two representing the range of the number of child terms.}

\item{p_stop}{The probability of a term to stop growing.}

\item{max}{Maximal number of terms.}

\item{verbose}{Whether to print messages.}

\item{dag}{An \code{ontology_DAG} object.}

\item{p_add}{The probability to add children on each term.}

\item{new_children}{The number or range of numbers of new children if a term is selected to add more children.}

\item{add_random_children_fun}{A function to randomly add children from the DAG.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Generate a random DAG
}
\details{
\code{dag_random_tree()} generates a random DAG tree from the root term. In a certain step of
the growing, let's denote the set of all leaf terms as L, then in the next round of growing,
\code{floor(length(L)*p_stop)} leaf terms stop growing, and for the remaining leaf terms that
continue to grow, each term will add child terms with number in uniformly sampled within \verb{[ n_children[1], n_children[2] ]}.
The growing stops when the total number of terms in the DAG exceeds \code{max}.

\code{dag_add_random_children()} adds more links in a DAG. Each term is associated with a probability \code{p_add}
to add new links where the term, if it is selected, is as a parent term, linking to other terms in the DAG.
The number of new child terms is controlled by \code{new_children} which can be a single number of a range. By default,
new child terms of a term \code{t} are randomly selected from other terms that are lower than the term \code{t}
(check the function \code{simona:::add_random_children}). The way how to randomly select new child terms for \code{t}
can be controlled by a self-defined function for the \code{add_random_children_fun} argument.

\code{dag_random()}: it simply wraps \code{dag_random_tree()} and \code{dag_add_random_children()}.
}
\examples{
tree = dag_random_tree()
dag = dag_random()
}
