% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{dag_enrich_on_offsprings}
\alias{dag_enrich_on_offsprings}
\title{Enrichment analysis on offspring terms}
\usage{
dag_enrich_on_offsprings(dag, terms, min_hits = 3, min_offspring = 10)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names.}

\item{min_hits}{Minimal number of terms in an offspring set.}

\item{min_offspring}{Minimal size of the offspring set.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{term}: Term names.
\item \code{n_hits}: Number of terms in \code{terms} intersecting to \code{t}'s offspring terms.
\item \code{n_offspring}: Number of offspring terms of \code{t} (including \code{t} itself).
\item \code{n_terms}: Number of terms in \code{term} intersecting to all terms in the DAG.
\item \code{n_all}: Number of all terms in the DAG.
\item \code{log2_fold_enrichment}: Defined as log2(observation/expected).
\item \code{z_score}: Defined as (observed-expected)/sd.
\item \code{p_value}: P-values from hypergeometric test.
\item \code{p_adjust}: Adjusted p-values from the BH method.
}

The number of rows in the data frame is the same as the number of terms in the DAG.
}
\description{
The analysis task is to evaluate how significant a term includes \code{terms}.
}
\details{
Given a list of terms in \code{terms}, the function tests whether they are enriched in a term's offspring terms.
The test is based on the hypergeometric distribution. In the following 2x2 contigency table, \code{S} is the set of \code{terms},
for a term \code{t} in the DAG, \code{T} is the set of its offspring plus the \code{t} itself, the aim is to test whether \code{S} is over-represented
in \code{T}.

If there is a significant p-value, we can say the term \code{t} preferably includes terms in \code{term}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{+----------+------+----------+-----+
|          | in S | not in S | all |
+----------+------+----------+-----+
| in T     |  x11 |    x12   | x10 |
| not in T |  x21 |    x22   | x20 |
+----------+------+----------+-----+
| all      |  x01 |    x02   |  x  |
+----------+------+----------+-----+
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
dag = create_ontology_DAG_from_GO_db() 
terms = random_terms(dag, 100)
df = dag_enrich_on_offsprings(dag, terms)
}
1
}
