% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transverse.R
\name{dag_distinct_ancestors}
\alias{dag_distinct_ancestors}
\title{Distinct ancestors of a list of terms}
\usage{
dag_distinct_ancestors(
  dag,
  terms,
  in_labels = TRUE,
  verbose = simona_opt$verbose
)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names.}

\item{in_labels}{Whether the terms are represented in their names or as integer indices?}

\item{verbose}{Whether to print messages.

Consider a subgraph that contains \code{terms} and their offspring terms, induced from the complete DAG.
the returned subset of terms are those with zero in-degree, or have no finite directional distance
from others in the subgraph.}
}
\value{
An integer vector or a character vector depending on the value of \code{in_labels}.
}
\description{
For a given list of terms, it returns a subset of terms which have
no ancestor relations to each other.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
dag_distinct_ancestors(dag, c("c", "d", "e", "f"))
}
