% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{dag_as_igraph}
\alias{dag_as_igraph}
\title{Convert to an igraph object}
\usage{
dag_as_igraph(dag)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}
}
\value{
An \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} object.
}
\description{
Convert to an igraph object
}
\details{
If \code{relations} is already set in \code{\link[=create_ontology_DAG]{create_ontology_DAG()}}, relations are also set as an edge attribute in the \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} object.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
dag_as_igraph(dag)
}
