% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{oneSignPlot}
\alias{oneSignPlot}
\title{Scatterplot for a single signature}
\usage{
oneSignPlot(data, whichSign, statistics = NULL)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{whichSign}{character string saying the signature to plot. This must
be a signature computed with signifinder.}

\item{statistics}{character string saying the statistics to be plotted in the
graph. Either one of "mean", "median" or "quantiles".}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Given signatures' scores, it returns a scatterplot of samples' scores and a
barplot of the density distribution of samples' scores.
}
\examples{
data(ovse)
oneSignPlot(data = ovse, whichSign = "Ferroptosis_Ye")

}
