% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor.R
\docType{methods}
\name{tail}
\alias{tail}
\alias{tail,gessResult-method}
\alias{tail,feaResult-method}
\title{Return the Last Part of an Object}
\usage{
\S4method{tail}{gessResult}(x, n = 6L, ...)

\S4method{tail}{feaResult}(x, n = 6L, ...)
}
\arguments{
\item{x}{an object}

\item{n}{a single integer. If positive or zero, size for the resulting 
object is the number of rows for a data frame. If negative, all but the n 
first number of rows of x.}

\item{...}{arguments to be passed to or from other methods}
}
\value{
data.frame
}
\description{
Return the last part of the result table in the \code{\link{gessResult}}, 
and \code{\link{feaResult}} objects
}
\examples{
gr <- gessResult(result=dplyr::tibble(pert=letters[seq_len(10)], 
                                      val=seq_len(10)), 
                 query=list(up=c("g1","g2"), down=c("g3","g4")),
                 gess_method="LINCS", refdb="path/to/lincs/db")
tail(gr)
fr <- feaResult(result=dplyr::tibble(id=letters[seq_len(10)], 
                                     val=seq_len(10)),
                organism="human", ontology="MF", drugs=c("d1", "d2"), 
                targets=c("t1","t2"))
tail(fr)
}
