% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mabsAnalyser.R
\name{mabsKEGG}
\alias{mabsKEGG}
\title{MeanAbs Enrichment Analysis for KEGG}
\usage{
mabsKEGG(
  geneList,
  organism = "hsa",
  keyType = "kegg",
  nPerm = 1000,
  minGSSize = 5,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  readable = FALSE
)
}
\arguments{
\item{geneList}{named numeric vector with gene/target ids in the name slot 
decreasingly ranked by scores in the data slot.}

\item{organism}{supported organism listed in 
URL: http://www.genome.jp/kegg/catalog/org_list.html}

\item{keyType}{one of 'kegg', 'ncbi-geneid', 'ncib-proteinid' and 'uniprot'}

\item{nPerm}{permutation numbers}

\item{minGSSize}{integer, minimum size of each gene set in annotation system}

\item{maxGSSize}{integer, maximum size of each gene set in annotation system}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{readable}{TRUE or FALSE indicating whether to convert gene Entrez ids
to gene Symbols in the 'itemID' column in the FEA result table.}
}
\value{
\code{\link{feaResult}} object
}
\description{
MeanAbs enrichment analysis with KEGG pathways.
}
\examples{
# Gene Entrez id should be used for KEGG enrichment
data(geneList, package="DOSE")
#geneList[100:length(geneList)]=0
#mk <- mabsKEGG(geneList=geneList, pvalueCutoff = 1)
#head(mk)
}
