% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_treat_info.R
\name{getTreats}
\alias{getTreats}
\title{Get Treatment Information}
\usage{
getTreats(refdb, sep = TRUE)
}
\arguments{
\item{refdb}{character(1), one of "lincs", "lincs_expr", "cmap" or "cmap_expr"
when using the pre-generated CMAP/LINCS databases or path to the HDF5 file
generated with the \code{\link{build_custom_db}} function. The details is 
shown in the 'refdb' argument of the \code{\link{qSig}} function}

\item{sep}{TRUE or FALSE, whether to separate the treatments or column names 
of the reference database into 'pert', 'cell' and 'pert_type'.}
}
\value{
character vector if \code{sep} argument is set as FALSE. 
Tibble object with 'pert', 'cell', 'pert_type' columns if \code{sep} is TRUE
}
\description{
Get treatment information including perturbation name, cell type and 
perturbation type from the reference database
}
\examples{
refdb <- system.file("extdata", "sample_db.h5", package="signatureSearch")
treat_info <- getTreats(refdb, sep=TRUE)
}
