% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gess_res_summary.R
\name{gess_res_vis}
\alias{gess_res_vis}
\title{GESS Result Visualization}
\usage{
gess_res_vis(gess_tb, drugs, col, cell_group = "all", ...)
}
\arguments{
\item{gess_tb}{tibble in the 'result' slot of the \code{\link{gessResult}} 
object, can be extracted via \code{\link{result}} accessor function}

\item{drugs}{character vector of selected drugs}

\item{col}{character(1), name of the score column in 'gess_tb', e.g., "NCS"
if the result table is from LINCS method. Can also be set as "rank", 
this way it will show the ranks of each drug in different cell types.}

\item{cell_group}{character(1), one of "all", "normal", or "tumor". 
If "all", it will show scores of each drug in both tumor and normal cell 
types. If "normal" or "tumor", it will only show normal or tumor cell types.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{geom_point}}}
}
\value{
plot visualizing GESS results
}
\description{
The function allows to summarize the ranking scores of selected
perturbagens for GESS results across cell types along with cell type 
classifications, such as normal and tumor cells. In the resulting plot
the perturbagens are drugs (along x-axis) and the ranking scores are LINCS'
NCS values (y-axis). For each drug the NCS values are plotted for each cell
type as differently colored dots, while their shape indicates the cell type
class.
}
\examples{
gr <- gessResult(result=dplyr::tibble(pert=c("p1", "p1", "p2", "p3"),
                                      cell=c("MCF7", "SKB", "MCF7", "SKB"),
                                      type=rep("trt_cp", 4),
                                      NCS=c(1.2, 1, 0.9, 0.6)),
                 query=list(up="a", down="b"), 
                 gess_method="LINCS", refdb="path/to/refdb")
gess_res_vis(result(gr), drugs=c("p1","p2"), col="NCS")
}
\references{
Subramanian, A., Narayan, R., Corsello, S. M., Peck, D. D., 
Natoli, T. E., Lu, X., Golub, T. R. (2017). A Next Generation 
Connectivity Map: L1000 Platform and the First 1,000,000 Profiles. Cell, 
171 (6), 1437-1452.e17. URL: https://doi.org/10.1016/j.cell.2017.10.049
}
