% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gctx2h5}
\alias{gctx2h5}
\title{Convert GCTX to HDF5 File}
\usage{
gctx2h5(gctx, cid, new_cid = cid, h5file, by_ncol = 5000, overwrite = TRUE)
}
\arguments{
\item{gctx}{character(1), path to gctx file from LINCS}

\item{cid}{character or integer vector referencing the
columns of the matrix to include}

\item{new_cid}{character vector of the same length as cid, assigning new
column names to matrix}

\item{h5file}{character(1), path of the hdf5 destination file}

\item{by_ncol}{number of columns to import in each iteration to limit 
memory usage}

\item{overwrite}{TRUE or FALSE, whether to overwrite or to append to 
existing 'h5file'}
}
\value{
HDF5 file
}
\description{
Read matrix-like data from large gctx file in chunks and write result back 
to an HDF5 file.
}
\examples{
gctx <- system.file("extdata", "test_sample_n2x12328.gctx", 
        package="signatureSearch")
h5file <- tempfile(fileext=".h5")
gctx2h5(gctx, cid=1:2, 
        new_cid=c('sirolimus__MCF7__trt_cp', 'vorinostat__SKB__trt_cp'), 
        h5file=h5file, overwrite=TRUE)
}
