% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{feaResult}
\alias{feaResult}
\title{Constructor for \code{\link{feaResult-class}}}
\usage{
feaResult(
  result,
  organism = "UNKNOWN",
  ontology = "UNKNOWN",
  drugs = "UNKNOWN",
  targets = "UNKNOWN"
)
}
\arguments{
\item{result}{tibble object containing the FEA results}

\item{organism}{character(1), organism information of the annotation system}

\item{ontology}{character(1), ontology type of the GO annotation system. 
If the annotation system is KEGG, it will be 'KEGG'}

\item{drugs}{character vector, input drug names used for the enrichment test}

\item{targets}{character vector, gene labels of the gene/protein targets 
for the drugs}
}
\value{
\code{feaResult} object
}
\description{
This is a helper function to construct a \code{feaResult} object. For 
detail description, please consult the help file of the 
\code{\link{feaResult-class}}.
}
\examples{
fr <- feaResult(result=dplyr::tibble(id=letters[seq_len(10)], 
                                     val=seq_len(10)),
                organism="human", ontology="MF", drugs=c("d1", "d2"), 
                targets=c("t1","t2"))
}
