% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{addMOA}
\alias{addMOA}
\title{Add MOA annotation to drug data frame}
\usage{
addMOA(df, drug_col, moa_list)
}
\arguments{
\item{df}{data frame that must contains a column with compound names}

\item{drug_col}{character (1), name of the column that stores compound names}

\item{moa_list}{a list object of MOA name (e.g. HDAC inhibitor) to compound
name mappings}
}
\value{
data frame with an added MOAss column
}
\description{
The MOA annotation is a list of MOA name to drug name mappings. 
This functions add the MOA column to data frame when data frame have a 
column with compound names
}
\examples{
data("clue_moa_list")
df <- data.frame(pert=c("vorinostat", "sirolimus"), annot1=c("a", "b"), 
                 annot2=1:2)
addMOA(df, "pert", clue_moa_list) 
}
