% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statT.R
\name{statT}
\alias{statT}
\title{t-test}
\usage{
statT(normMatrix, repIndex, normRows = NULL, normCols = NULL,
  testSide = "two.sided", trueMean = 0)
}
\arguments{
\item{normMatrix}{Data frame or numeric matrix of normalized data. Columns are plates, and rows are plate wells.}

\item{repIndex}{Integer vector indicating replicates in normMatrix. Which plates are replicates of each other? Provide the same number for plates belonging to a replicate group. Each index in the vector matches the corresponding column of normMatrix.}

\item{normRows, normCols}{Optional integer vector. Indicate which row/column numbers from the normMatrix should be tested. If NULL then all rows/columns from the normMatrix are used.}

\item{testSide}{Optional. Type of t-test: 'two.sided', 'less', or 'greater'. Default is 'two.sided'.}

\item{trueMean}{Optional. Number indicating true value of mean. Default is 0.}
}
\value{
A matrix of parameters for each replicate group is returned:
\item{T-statistic}{Value of the t-statistic.}
\item{Mean_Difference}{Difference between the calculated and the true mean.}
\item{Standard_Error}{Standard error of the difference between means.}
\item{Degrees_Of_Freedom}{Degrees of freedom for the t-statistic.}
\item{P-value}{P-value for the t-test.}
}
\description{
Apply one-sample t-test separately to each plate
}
\details{
Standard one-sample t-test is applied to the normalized data.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(dataMatrix = ex_dataMatrix, dataCols = 5:10,
normMethod = 'normZ')
## apply T test to normalized data matrix and get the p-values
ex_testMatrix <- statT(normMatrix = ex_normMatrix, trueMean = 0,
repIndex = c(1,1,1,2,2,2))

}
\seealso{
Other statistical methods: \code{\link{statFDR}},
  \code{\link{statRVM}}
}

