% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSights.R
\name{plotSights}
\alias{plotSights}
\title{Graphical devices}
\usage{
plotSights(plotMethod, plotMatrix, plateRows, plateCols, repIndex = NULL,
  plotRows = NULL, plotCols = NULL, plotName = NULL, plotSep = TRUE,
  plotAll = FALSE, colNames = NULL, ...)
}
\arguments{
\item{plotMethod}{Plotting method name from SIGHTS ('3d', 'Autoco', 'Box', 'Heatmap', 'Hist', 'IGFit', or 'Scatter').}

\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells. For plotMethod 'Hist', this is a p-value matrix with each column a single sample.}

\item{plateRows, plateCols}{Number of rows/columns in plate. Applies to plotMethods '3d', 'Autoco' and 'Heatmap'.}

\item{repIndex}{Vector of labels indicating replicate group. Each index in the vector matches the corresponding column of plotMatrix. Applies to plotMethods 'Box',  'Scatter' and 'IGFit'.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{plotSep}{Optional logical. Should plots be presented in separate windows? Default is TRUE. Applies to plotMethods 'Autoco', 'Box', 'Hist' and 'Heatmap'. For 'Box', each replicate group is presented in a separate window and it only applies if repIndex is not NULL.}

\item{plotAll}{Optional logical. Should all p-values be plotted together? Default is FALSE. Applies to plotMethod 'Hist'.}

\item{colNames}{Optional. Names of plotCols for plot title. Applies to plotMethod 'Hist'.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{ggplot}} functions.}
}
\value{
List of lattice objects for 'plot3d'. Modifiable ggplot2 object or list of objects for all others.
}
\description{
Apply any of the available SIGHTS graphical devices
}
\details{
One of the following SIGHTS graphical devices may be chosen: \code{\link{plot3d}}, \code{\link{plotAutoco}}, \code{\link{plotBox}}, \code{\link{plotHeatmap}}, \code{\link{plotHist}}, \code{\link{plotIGFit}}, or \code{\link{plotScatter}}. See their individual help pages for more details.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(normMethod = 'RobZ', dataMatrix = ex_dataMatrix,
dataCols = 5:10, wellCorrection = TRUE)
## choose a graphical device and provide relevant information
plotSights(plotMethod = 'Autoco', plotMatrix = ex_normMatrix,
plotName = 'Example', plateRows = 8, plateCols = 10)

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/25190066}{Murie et al. (2015). Improving detection of rare biological events in high-throughput screens. Journal of Biomolecular Screening, 20(2), 230-241.}
}
\seealso{
Other SIGHTS functions: \code{\link{normSights}},
  \code{\link{statSights}}
}

