% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIGFit.R
\name{plotIGFit}
\alias{plotIGFit}
\title{Inverse gamma}
\usage{
plotIGFit(plotMatrix, repIndex, plotRows = NULL, plotCols = NULL,
  plotName = NULL, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{repIndex}{Optional. Vector of labels indicating replicate group. Each index in the vector matches the corresponding column of plotMatrix. If NULL then all plates are plotted together without grouping.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_step}}.}
}
\value{
Modifiable ggplot2 object
}
\description{
Plot an inverse gamma fit plot for all plates together
}
\details{
Inverse gamma fit plot can be used to check if RVM test (\code{\link{statRVM}}) assumptions are valid and it can be applied to the data.
}
\examples{
## load dataset
data(ex_dataMatrix)

## normalize data matrix using any method and store in new variable
ex_normMatrix <- normSights(dataMatrix = ex_dataMatrix, dataCols = 5:10,
normMethod = 'normZ')
## plot normalized data
plotIGFit(plotMatrix = ex_normMatrix, repIndex = c(1,1,1,2,2,2),
plotName = 'Example')

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotAutoco}}, \code{\link{plotBox}},
  \code{\link{plotHeatmap}}, \code{\link{plotHist}},
  \code{\link{plotScatter}}
}

