% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBox.R
\name{plotBox}
\alias{plotBox}
\title{Boxplot}
\usage{
plotBox(plotMatrix, plotRows = NULL, plotCols = NULL, plotName = NULL,
  repIndex = NULL, plotSep = TRUE, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{repIndex}{Optional. Vector of labels indicating replicate group. Each index in the vector matches the corresponding column of plotMatrix. If NULL then all plates are plotted together without grouping.}

\item{plotSep}{Optional logical. Should plots of different replicate groups be presented in separate windows? Default is TRUE. Does not apply if repIndex is NULL.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_boxplot}}.}
}
\value{
Modifiable ggplot2 object or list of objects
}
\description{
Construct an ordered boxplot for each plate
}
\details{
Box plots can be used to identify scaling shifts among replicates and view the general distribution of data among all plates.
}
\examples{
## load dataset
data(ex_dataMatrix)

## plot raw data
plotBox(plotMatrix = ex_dataMatrix, repIndex = c(1,1,1,2,2,2), plotCols = 5:10,
plotName = 'Example')
## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## plot normalized data
plotBox(plotMatrix = ex_normMatrix, repIndex = c(1,1,1,2,2,2), plotName = 'Example')

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotAutoco}}, \code{\link{plotHeatmap}},
  \code{\link{plotHist}}, \code{\link{plotIGFit}},
  \code{\link{plotScatter}}
}

