% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3d.R
\name{plot3d}
\alias{plot3d}
\title{3D plot}
\usage{
plot3d(plotMatrix, plateRows, plateCols, plotRows = NULL, plotCols = NULL,
  plotName = NULL)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}
}
\value{
List of lattice objects
}
\description{
Plot a three-dimensional plot for each plate
}
\details{
3d plots can be used to assess the existence of spatial bias on a plate  by plate basis. Spatial bias can be visually  subtle, however, and sometimes difficult to detect with 3d plots. Auto-correlation  plots (\code{\link{plotAutoco}}) can circumvent this problem.
}
\examples{
## load dataset
data(ex_dataMatrix)

## plot raw data
plot3d(plotMatrix = ex_dataMatrix, plotCols = 5:10,
plotName = 'Example', plateRows = 8, plateCols = 10)
## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## plot normalized data
plot3d(plotMatrix = ex_normMatrix, plotName = 'Example',
plateRows = 8, plateCols = 10)

}
\seealso{
Other graphical devices: \code{\link{plotAutoco}},
  \code{\link{plotBox}}, \code{\link{plotHeatmap}},
  \code{\link{plotHist}}, \code{\link{plotIGFit}},
  \code{\link{plotScatter}}
}

