% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normZ.R
\name{normZ}
\alias{normZ}
\title{Normalization by Z score method}
\usage{
normZ(dataMatrix, dataRows = NULL, dataCols = NULL)
}
\arguments{
\item{dataMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{dataRows, dataCols}{Optional integer vector. Indicate which row/column numbers from the dataMatrix should be normalized. If NULL then all rows/columns from the dataMatrix are used.}
}
\value{
Numeric matrix of normalized data in the same format as dataMatrix
}
\description{
Apply Z score to data
}
\details{
Z score normalization subtracts the mean of the raw well intensities of a given plate from the signal intensity of a given compound and divides it by the standard deviation of the raw well intensities of that plate.
}
\note{
For information on how to arrange your dataset for dataMatrix, please see (\code{\link{ex_dataMatrix}})
}
\examples{
## load dataset
data(ex_dataMatrix)

## apply Z score
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)

}
\seealso{
Other normalization methods: \code{\link{normLoess}},
  \code{\link{normMedFil}}, \code{\link{normRobZ}},
  \code{\link{normR}}, \code{\link{normSPAWN}}
}

