% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runShinyMethyl.R
\name{runShinyMethyl}
\alias{runShinyMethyl}
\title{Run the interactive shinyMethyl session}
\usage{
runShinyMethyl(shinyMethylSet1, shinyMethylSet2 = NULL)
}
\arguments{
\item{shinyMethylSet1}{\code{shinyMethylSet} that must be extracted from
an \code{RGChannelSet} object.}

\item{shinyMethylSet2}{Optional \code{shinyMethylSet} that must be
extracted from a \code{GenomicRatioSet}.}
}
\value{
No value returned. Instead the shinyMethyl interactive
    session is launched.
}
\description{
Function to run the interactive shinyMethyl session
    from a shinyMethylSet object.
}
\examples{
if (interactive()){
library(minfi)
library(minfiData)
baseDir <- system.file("extdata", package = "minfiData")
targets <- read.metharray.sheet(baseDir)
targets$Sample_Plate <- substr(targets$Slide,1,7)
RGSet <- read.metharray.exp(targets=targets)
summarized.data <- shinySummarize(RGSet)
runShinyMethyl(summarized.data)
}
}
\seealso{
\code{\link{shinyMethylSet}}
}
\author{
Jean-Philippe Fortin
}
