% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualChannels.R
\name{visual_channel_color}
\alias{visual_channel_color}
\title{color visual channel}
\usage{
visual_channel_color(
  field = NULL,
  title = NULL,
  type = NULL,
  scaleOffset = NULL,
  scale = NULL,
  legend = NULL,
  grid = NULL,
  axis = NULL,
  aggregate = NULL,
  ...
)
}
\arguments{
\item{field}{A character. Name of the data field.}

\item{title}{A character. Title of the legend. Default: undefined.}

\item{type}{A character. Must be "genomic". Specify the data type.}

\item{scaleOffset}{A number vector of the form c(1, 2). Whether
to use offset of the domain proportionally. This is bound to brushes
on the color legend. Default: c(0, 1).}

\item{scale}{A character. One of "linear", "log".}

\item{legend}{A Boolean. Whether to display legend. Default: FALSE.}

\item{grid}{A Boolean. Whether to display grid. Default: FALSE.}

\item{axis}{A character. One of "none", "top", "bottom", "left", "right".
Specify where should the axis be put.}

\item{aggregate}{A character. One of "max", "min", "mean", "bin", "count".
Specify how to aggregate data. Default: undefined.}

\item{...}{Any other parameters to pass to gosling.js.}
}
\value{
List object.
}
\description{
color visual channel
}
\details{
For more info visit
http://gosling-lang.org/docs/visual-channel#color
}
\examples{
if(interactive()) {
  library(shiny)
  library(shiny.gosling)

  # View 2 Track 3----
  view2_track3_data <- track_data(
    url = "https://server.gosling-lang.org/api/v1/tileset_info/?d=NC_045512_2-multivec",
    type = "multivec",
    row = "base",
    column = "position",
    value = "count",
    categories = c("A", "T", "G", "C"),
    start = "start",
    end = "end"
  )

  view2_track3a <- add_single_track(
    mark = "bar",
    y = visual_channel_y(
      field = "count", type = "quantitative", axis = "none"
    )
  )

  view2_track3b <- add_single_track(
    dataTransform = track_data_transform(
      type = "filter",
      field = "count",
      oneOf = list(0),
      not = TRUE
    ),
    mark = "text",
    x = visual_channel_x(
      field = "start", type = "genomic"
    ),
    xe = visual_channel_x(
      field = "end", type = "genomic"
    ),
    size = 24,
    color = "white",
    visibility = list(list(
      operation = "less-than",
      measure = "width",
      threshold = "|xe-x|",
      transitionPadding = 30,
      target = "mark"
    ),
    list(
      operation = "LT",
      measure = "zoomLevel",
      threshold = 40,
      target = "track"
    ))
  )

  view2_track3_x <- visual_channel_x(
    field = "position", type = "genomic"
  )

  view2_track3_color <- visual_channel_color(
    field = "base",
    type = "nominal",
    domain = c("A", "T", "G", "C"),
    legend = TRUE
  )

  view2_track3_text <- visual_channel_text(
    field = "base", type = "nominal"
  )

  view2_track3_style <- default_track_styles(
    inlineLegend = TRUE
  )

  view2_track3 <- add_single_track(
    title = "NC_045512.2 Sequence",
    alignment = "overlay",
    data = view2_track3_data,
    tracks = add_multi_tracks(
      view2_track3a, view2_track3b
    ),
    x = view2_track3_x,
    color = view2_track3_color,
    text = view2_track3_text,
    style = view2_track3_style,
    width = 800, height = 40
  )

  view2 <- compose_view(
    multi = TRUE,
    centerRadius = 0,
    xDomain = list(interval = c(1, 29903)),
    linkingId = "detail",
    alignment = "stack",
    tracks = add_multi_tracks(
      view2_track3
    )
  )

  combined_view <- arrange_views(
    title = "SARS-CoV-2",
    subtitle = "Data Source: WashU Virus Genome Browser, NCBI, GISAID",
    assembly = list(list("NC_045512.2", 29903)),
    layout = "linear",
    spacing = 50,
    views = list(view2),
    listify = FALSE
  )

  ui <- fluidPage(
    use_gosling(),
    fluidRow(
      column(6, goslingOutput("gosling_plot"))
    )
  )


  server <- function(input, output, session) {
    output$gosling_plot <- renderGosling({
      gosling(
        component_id = "sars_cov2",
        combined_view
      )
    })
  }

  shinyApp(ui, server)

}

}
