% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{track_data_gr}
\alias{track_data_gr}
\title{Data object builder for a GRanges object by locally saving it}
\usage{
track_data_gr(
  granges,
  chromosomeField = NULL,
  genomicFields = NULL,
  separator = ",",
  sampleLength = 1000,
  headerNames = NULL,
  ...
)
}
\arguments{
\item{granges}{A GRanges object from the GenomicRanges package with seqnames and ranges}

\item{chromosomeField}{A character. Specify the name of chromosome data fields.}

\item{genomicFields}{A character vector. Specify the name of genomic data fields.}

\item{separator}{A character. Specify file separator, Default: ','}

\item{sampleLength}{A number. Specify the number of rows loaded from
the URL. Default: 1000}

\item{headerNames}{A character vector. Specify the names of data fields
if a CSV file does not have header row.}

\item{...}{Any other parameters passed to json data object.}
}
\value{
list of data specs for a csv file
}
\description{
Build the data object for gosling plots
}
\examples{
if (interactive()) {
library(shiny.gosling)
library(shiny)
library(GenomicRanges)

url <- "https://rb.gy/7y3fx"
temp_file <- file.path(tempdir(), "GSM1295076_CBX6_BF_ChipSeq_mergedReps_peaks.bed.gz")
download.file(url, destfile = temp_file)
df <- read.delim(
  temp_file,
  header = FALSE,
  comment.char = "#"
)
gr <- GRanges(
  seqnames = df$V1,
  ranges = IRanges(df$V2, df$V3)
)

ui <- fluidPage(
  use_gosling(clear_files = FALSE),
  goslingOutput("gosling_plot")
)

track_1 <- add_single_track(
  width = 800,
  height = 180,
  data = track_data_gr(
    gr, chromosomeField = "seqnames",
    genomicFields = c("start", "end")
  ),
  mark = "bar",
  x = visual_channel_x(
    field = "start", type = "genomic", axis = "bottom"
  ),
  xe = visual_channel_x(field = "end", type = "genomic"),
  y = visual_channel_y(
    field = "width", type = "quantitative", axis = "right"
  ),
  size = list(value = 5)
)

composed_view <- compose_view(
  layout = "linear",
  tracks = track_1
)

arranged_view <- arrange_views(
  title = "Basic Marks: bar",
  subtitle = "Tutorial Examples",
  views = composed_view
)

server <- function(input, output, session) {
  output$gosling_plot <- renderGosling({
    gosling(
      component_id = "component_1",
      arranged_view
    )
  })
}

shiny::shinyApp(ui, server)
}

}
