#' Export PNG
#' @description
#' Exports PNG
#' @param component_id A character. The id of the component_id prop
#' passed to the
#' GoslingComponent function.
#' @param transparent_background A Boolean. Determine if the background
#' should be transparent or not (Default: false).
#' @param session A shiny session object.
#' @examples
#' if(interactive()) {
#'   library(shiny)
#'   library(shiny.gosling)
#'
#'   cistrome_data <-
#'     "https://server.gosling-lang.org/api/v1/tileset_info/?d=cistrome-multivec"
#'
#'   single_track <- add_single_track(
#'     id = "track1",
#'     data = track_data(
#'       url = cistrome_data,
#'       type = "multivec",
#'       row = "sample",
#'       column = "position",
#'       value = "peak",
#'       categories = c("sample 1", "sample 2", "sample 3", "sample 4"),
#'       binSize = 4,
#'     ),
#'     mark = "rect",
#'     x = visual_channel_x(field = "start", type = "genomic", axis = "top"),
#'     xe = visual_channel_x(field = "end", type = "genomic"),
#'     row = visual_channel_row(
#'       field = "sample",
#'       type = "nominal",
#'       legend = TRUE
#'     ),
#'     color = visual_channel_color(
#'       field = "peak",
#'       type = "quantitative",
#'       legend = TRUE
#'     ),
#'     tooltip = visual_channel_tooltips(
#'       visual_channel_tooltip(field = "start", type = "genomic",
#'                              alt = "Start Position"),
#'       visual_channel_tooltip(field = "end", type = "genomic",
#'                              alt = "End Position"),
#'       visual_channel_tooltip(
#'         field = "peak",
#'         type = "quantitative",
#'         alt = "Value",
#'         format = "0.2"
#'       )
#'     ),
#'     width = 600,
#'     height = 130
#'   )
#'
#'   single_composed_track <- compose_view(
#'     tracks = single_track
#'   )
#'
#'   single_composed_views <- arrange_views(
#'     title = "Single Track",
#'     subtitle = "This is the simplest single track visualization with a linear layout",
#'     layout = "circular", #"linear"
#'     views = single_composed_track,
#'     xDomain = list(
#'       chromosome = "chr1",
#'       interval = c(1, 3000500)
#'     )
#'   )
#'
#'   ui <- fluidPage(
#'     use_gosling(),
#'     fluidRow(
#'       column(6, goslingOutput("gosling_plot")),
#'       column(
#'         1, br(), actionButton(
#'           "download_png",
#'           "PNG",
#'           icon = icon("cloud-arrow-down")
#'         )
#'       )
#'     )
#'   )
#'
#'
#'   server <- function(input, output, session) {
#'     output$gosling_plot <- renderGosling({
#'       gosling(
#'         component_id = "component_1",
#'         single_composed_views,
#'         clean_braces = TRUE
#'       )
#'     })
#'
#'     observeEvent(input$download_png, {
#'       export_png(component_id = "component_1")
#'     })
#'   }
#'
#'   shinyApp(ui, server)
#'
#' }
#'
#' @return None.
#' @importFrom shiny getDefaultReactiveDomain
#' @export
export_png <- function(component_id, transparent_background = FALSE,
                       session = getDefaultReactiveDomain()) {
  session$sendCustomMessage(
    "export_png",
    list(
      component_id = component_id,
      transparent_background = transparent_background
    )
  )
}
