% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cwl.R
\docType{class}
\name{CPURequirement-class}
\alias{CPURequirement-class}
\alias{CPURequirement}
\alias{cpu}
\alias{docker}
\alias{requirements}
\alias{fileDef}
\alias{MemRequirement-class}
\alias{MemRequirement}
\alias{mem}
\alias{AWSInstanceTypeRequirement-class}
\alias{AWSInstanceTypeRequirement}
\alias{aws}
\alias{AnyRequirement-class}
\alias{AnyRequirement}
\alias{anyReq}
\title{Rabix specifc Requirements}
\usage{
docker(
  pull = NULL,
  imageId = NULL,
  load = NULL,
  file = NULL,
  output = NULL,
  dockerPull = pull,
  dockerImageId = imageId,
  dockerLoad = load,
  dockerFile = file,
  dockerOutputDirectory = output,
  ...
)

requirements(...)

fileDef(name = NULL, content = NULL)
}
\arguments{
\item{pull}{[short form argument] Docker Repository[:Tag] like rocker/r-base}

\item{imageId}{[short form argument] The image id that will be used for
docker run, imageId Optionally set the id of image you get from SDK.}

\item{load}{[short form argument] Specify a HTTP URL from which to download
a Docker image using docker load.}

\item{file}{[short form argument] Supply the contents of a Dockerfile
which will be built using docker build.}

\item{output}{[short form argument] Set the designated output directory
to a specific location inside the Docker container.}

\item{dockerPull}{Docker Repository[:Tag] like rocker/r-base}

\item{dockerImageId}{The image id that will be used for docker run,
imageId Optionally set the id of image you get from SDK.}

\item{dockerLoad}{Specify a HTTP URL from which to download a Docker
image using docker load.}

\item{dockerFile}{Supply the contents of a Dockerfile which will be
built using docker build.}

\item{dockerOutputDirectory}{Set the designated output directory to
a specific location inside the Docker container.}

\item{...}{extra aguments passed}

\item{name}{file name}

\item{content}{file content, could be script}
}
\value{
A Requirement subclass.
}
\description{
Extends ProcessRequirements. CPURequirement and MemRequirement to
setup CPU and Memory requiremnts.

requirements and hints
}
\details{
It constructs ProesssRequirementList object, or from a returned raw list contains or requirements.
}
\section{Fields}{

\describe{
\item{\code{value}}{[Integer] for CPU default is 1L, if 0L, use all
CPU. For mem, default is 1000L. Note: for CPU, 0L means
multi-tread, and non-zero value will be converted to 1L, which
means single thread.}
}}


\examples{
cpu(1)
CPURequirement(value = 1L)
docker("rocker/r-base")
requirements(docker("rocker/r-base"), cpu(1), mem(1024))
mem(2000)
MemRequirement(value = 2000L)
aws("c3.8xlarge")
anyReq("any")
}
