% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-utils.R
\name{get_cwl_class}
\alias{get_cwl_class}
\alias{is_commandlinetool}
\alias{is_workflow}
\title{Get class from CWL JSON file}
\usage{
get_cwl_class(input)
}
\arguments{
\item{input}{cwl json file path}
}
\value{
character for cwl class "Workflow" or "CommandLineTool"
}
\description{
Get class from CWL JSON file
}
\examples{
tool.in <- system.file("extdata/app", "tool_unpack_fastq.json", package = "sevenbridges")
flow.in <- system.file("extdata/app", "flow_star.json", package = "sevenbridges")
get_cwl_class(tool.in)
is_commandlinetool(tool.in)
is_workflow(tool.in)
get_cwl_class(flow.in)
is_commandlinetool(flow.in)
is_workflow(flow.in)
}
