% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{getCisPairs}
\alias{getCisPairs}
\title{Build a \code{\link{GInteractions}} object with all pairs of input
\code{\link[GenomicRanges:GRanges-class]{GRanges}} within a given distance.}
\usage{
getCisPairs(inGR, maxDist = 1e+06)
}
\arguments{
\item{inGR}{\code{\link[GenomicRanges:GRanges-class]{GRanges}} object of genomic regions.
The ranges should be sorted according to chr, strand, and start position.
Use \code{\link[BiocGenerics]{sort}} to sort it.}

\item{maxDist}{maximal distance in base-pairs between pairs of ranges as
single  numeric value.}
}
\value{
A \code{\link[InteractionSet:InteractionSet-class]{GInteractions}} object with all pairs
  within the given distance.
}
\description{
Distance is calculated from the center of input regions.
}
\examples{
# build example GRanges as input
inGR <- GRanges(
rep("chr1", 5),
IRanges(
  c(10, 20, 30, 100, 1000),
  c(15, 25, 35, 105, 1005)
)
)

# get all pairs within 50 bp
gi <- getCisPairs(inGR, maxDist = 50)

# getCisPiars returns a StrictGInteractions object
class(gi)

# The input regions are accessibly via regions()
regions(gi)

}
