% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualizeGene}
\alias{visualizeGene}
\title{Visualize Gene}
\usage{
visualizeGene(
  gene_name,
  betas,
  platform = NULL,
  genome = NULL,
  upstream = 2000,
  dwstream = 2000,
  ...
)
}
\arguments{
\item{gene_name}{gene name}

\item{betas}{beta value matrix (row: probes, column: samples)}

\item{platform}{HM450, EPIC, or MM285 (default)}

\item{genome}{hg19, hg38, or mm10 (default)}

\item{upstream}{distance to extend upstream}

\item{dwstream}{distance to extend downstream}

\item{...}{additional options, see visualizeRegion, assemble_plots}
}
\value{
None
}
\description{
Visualize the beta value in heatmaps for a given gene. The function takes
a gene name which is taken from the UCSC refGene. It searches all the
transcripts for the given gene and optionally extend the span by certain
number of base pairs. The function also takes a beta value matrix with
sample names on the columns and probe names on the rows. The function can
also work on different genome builds (default to hg38, can be hg19).
}
\examples{
betas <- sesameDataGet('HM450.76.TCGA.matched')$betas
visualizeGene('ADA', betas, 'HM450')
}
