% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileSet.R
\name{sliceFileSet}
\alias{sliceFileSet}
\title{Slice a fileSet with samples and probes}
\usage{
sliceFileSet(fset, samples = fset$samples, probes = fset$probes, memmax = 10^5)
}
\arguments{
\item{fset}{a sesame::fileSet, as obtained via readFileSet}

\item{samples}{samples to query (default to all samples)}

\item{probes}{probes to query (default to all probes)}

\item{memmax}{maximum items to read from file to memory, to protect from
accidental memory congestion.}
}
\value{
a numeric matrix of length(samples) columns and length(probes) rows
}
\description{
Slice a fileSet with samples and probes
}
\examples{

## create two samples
fset <- initFileSet('mybetas2', 'HM27', c('s1','s2'))

## a hypothetical numeric array (can be beta values, intensities etc)
hypothetical <- setNames(runif(fset$n), fset$probes)

## map the numeric to file
mapFileSet(fset, 's1', hypothetical)

## get data
sliceFileSet(fset, 's1', 'cg00000292')

}
