% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{sesameQC_calcStats}
\alias{sesameQC_calcStats}
\title{Calculate QC statistics}
\usage{
sesameQC_calcStats(sdf, funs = NULL)
}
\arguments{
\item{sdf}{a SigDF object}

\item{funs}{a sesameQC_calcStats_* function or a list of them
default to all functions. One can also use a string such as
"detection" or c("detection", "intensity") to reduce typing}
}
\value{
a sesameQC object
}
\description{
It is a function to call one or multiple
sesameQC_calcStats functions
}
\details{
currently supporting: detection, intensity, numProbes, channel,
dyeBias, betas
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
sesameQC_calcStats(sdf)
sesameQC_calcStats(sdf, "detection")
sesameQC_calcStats(sdf, c("detection", "channel"))
## retrieve stats as a list
sesameQC_getStats(sesameQC_calcStats(sdf, "detection"))
## or as data frames
as.data.frame(sesameQC_calcStats(sdf, "detection"))

}
