% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deidentify.R
\name{reIdentify}
\alias{reIdentify}
\title{Re-identify IDATs by restoring scrambled SNP intensities}
\usage{
reIdentify(path, out_path = NULL, snps = NULL, mft = NULL)
}
\arguments{
\item{path}{input IDAT file}

\item{out_path}{output IDAT file}

\item{snps}{SNP definition, if not given, default to SNP probes}

\item{mft}{sesame-compatible manifest if non-standard}
}
\value{
NULL, changes made to the IDAT files
}
\description{
This requries setting a seed with a secret number that was used to
de-identify the IDAT (see example).
This requires a secret number that was used to de-idenitfy the IDAT
}
\examples{

temp_out <- tempfile("test")

set.seed(123)
reIdentify(system.file(
    "extdata", "4207113116_A_Grn.idat", package = "sesameData"), temp_out)
unlink(temp_out)
}
