% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO.R
\name{parseGEOsignalMU}
\alias{parseGEOsignalMU}
\title{Convert signal M and U to SigDF}
\usage{
parseGEOsignalMU(
  sigM,
  sigU,
  Probe_IDs,
  oob.mean = 500,
  oob.sd = 300,
  platform = NULL
)
}
\arguments{
\item{sigM}{methylated signal, a numeric vector}

\item{sigU}{unmethylated signal, a numirc vector}

\item{Probe_IDs}{probe ID vector}

\item{oob.mean}{assumed mean for out-of-band signals}

\item{oob.sd}{assumed standard deviation for out-of-band signals}

\item{platform}{platform code, will infer if not given}
}
\value{
SigDF
}
\description{
This overcomes the issue of missing IDAT files. However,
out-of-band signals will be missing or faked (sampled from a
normal distribution).
}
\examples{
sigM <- c(11436, 6068, 2864)
sigU <- c(1476, 804, 393)
probes <- c("cg07881041", "cg23229610", "cg03513874")
sdf <- parseGEOsignalMU(sigM, sigU, probes, platform = "EPIC")
}
