% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/channel_inference.R
\name{inferInfiniumIChannel}
\alias{inferInfiniumIChannel}
\title{Infer and reset color channel for Type-I probes instead of
using what is specified in manifest. The results are stored to
sdf@extra$IGG and sdf@extra$IRR slot.}
\usage{
inferInfiniumIChannel(
  sdf,
  switch_failed = FALSE,
  mask_failed = FALSE,
  verbose = FALSE,
  summary = FALSE
)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{switch_failed}{whether to switch failed probes (default to FALSE)}

\item{mask_failed}{whether to mask failed probes (default to FALSE)}

\item{verbose}{whether to print correction summary}

\item{summary}{return summarized numbers only.}
}
\value{
a \code{SigDF}, or numerics if summary == TRUE
}
\description{
IGG => Type-I green that is inferred to be green
IRR => Type-I red that is inferred to be red
}
\examples{

sdf <- sesameDataGet('EPIC.1.SigDF')
inferInfiniumIChannel(sdf)

}
