% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_composition.R
\name{estimateLeukocyte}
\alias{estimateLeukocyte}
\title{Estimate leukocyte fraction using a two-component model}
\usage{
estimateLeukocyte(
  betas.tissue,
  betas.leuko = NULL,
  betas.tumor = NULL,
  platform = c("EPIC", "HM450", "HM27")
)
}
\arguments{
\item{betas.tissue}{tissue beta value matrix (#probes X #samples)}

\item{betas.leuko}{leukocyte beta value matrix,
if missing, use the SeSAMe default by infinium platform}

\item{betas.tumor}{optional, tumor beta value matrix}

\item{platform}{"HM450", "HM27" or "EPIC"}
}
\value{
leukocyte estimate, a numeric vector
}
\description{
The method assumes only two components in the mixture: the leukocyte
component and the target tissue component. The function takes the beta
values matrix of the target tissue and the beta value matrix of the
leukocyte. Both matrices have probes on the row and samples on the column.
Row names should have probe IDs from the platform. The function outputs
a single numeric describing the fraction of leukocyte.
}
\examples{

betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
estimateLeukocyte(betas.tissue)
sesameDataGet_resetEnv()

}
