% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection.R
\name{detectionPnegEcdf}
\alias{detectionPnegEcdf}
\title{Detection P-value based on ECDF of negative control}
\usage{
detectionPnegEcdf(sdf, return.pval = FALSE, pval.threshold = 0.05)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{return.pval}{whether to return p-values, instead of a
masked \code{SigDF}}

\item{pval.threshold}{minimum p-value to mask}
}
\value{
a \code{SigDF}, or a p-value vector if return.pval is TRUE
}
\description{
The function takes a \code{SigDF} as input, computes detection p-value
using negative control probes' empirical distribution and returns a new
\code{SigDF} with an updated mask slot.
}
\examples{
sdf <- sesameDataGet("EPIC.1.SigDF")
sum(sdf$mask)
sum(detectionPnegEcdf(sdf)$mask)
}
