% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_fetch_bamPE.R
\name{ssvFetchBamPE}
\alias{ssvFetchBamPE}
\title{ssvFetchBam for paired-end ChIP-seq files.
Only concordant reads are considered, but this has been minimally tested, please verify.}
\usage{
ssvFetchBamPE(
  file_paths,
  qgr,
  unique_names = NULL,
  win_size = 50,
  win_method = c("sample", "summary")[1],
  summary_FUN = stats::weighted.mean,
  fragLens = "not_used",
  anchor = c("left", "left_unstranded", "center", "center_unstranded")[3],
  names_variable = "sample",
  return_data.table = FALSE,
  max_dupes = Inf,
  n_cores = getOption("mc.cores", 1),
  n_region_splits = 1,
  min_isize = 1,
  max_isize = Inf,
  return_unprocessed = FALSE,
  return_fragSizes = FALSE,
  force_skip_centerFix = FALSE,
  ...
)
}
\arguments{
\item{file_paths}{character vector of file_paths to load from. Alternatively,
file_paths can be a data.frame or data.table whose first column is a
character vector of paths and additial columns will be used as metadata.}

\item{qgr}{Set of GRanges to query.  For valid results the width of each
interval should be identical and evenly divisible by \code{win_size}.}

\item{unique_names}{names to use in final data.table to designate source
bigwig. Default is 'sample'}

\item{win_size}{The window size that evenly divides widths in \code{qgr}.}

\item{win_method}{character.  one of c("sample", "summary").  Determines if
\code{\link{viewGRangesWinSample_dt}} or
\code{\link{viewGRangesWinSummary_dt}} is used to represent each region in
qgr.}

\item{summary_FUN}{function.  only relevant if win_method is "summary".
passed to \code{\link{viewGRangesWinSummary_dt}}.}

\item{fragLens}{never used by ssvFetchBamPE Ignore.}

\item{anchor}{character, one of c("center", "center_unstranded", "left",
"left_unstranded")}

\item{names_variable}{The column name where unique_names are stored.}

\item{return_data.table}{logical. If TRUE the internal data.table is returned
instead of GRanges.  Default is FALSE.}

\item{max_dupes}{numeric >= 1.  duplicate reads by strandd start position
over this number are removed, Default is Inf.}

\item{n_cores}{integer number of cores to use.}

\item{n_region_splits}{integer number of splits to apply to qgr. The query
GRanges will be split into this many roughly equal parts for increased
parallelization. Default is 1, no split.}

\item{min_isize}{integer. Read pairs must have an isize greater than or equal to this value.  Default is 1.}

\item{max_isize}{integer. Read pairs must have an isize less than or equal to this value.  Default is Inf.}

\item{return_unprocessed}{boolean. if TRUE returns read alignment in data.table. Default is FALSE.}

\item{return_fragSizes}{boolean. if TRUE returns fragment sizes for all reads per region.}

\item{force_skip_centerFix}{boolean, if TRUE all query ranges will be
used "as is".  This is already the case by default if win_method == "summary"
but may have applications where win_method == "sample".}

\item{...}{passed to Rsamtools::ScanBamParam()
Uses mc.cores option if not supplied.}
}
\value{
A tidy formatted GRanges (or data.table if specified) containing
fetched values.
}
\description{
Iterates a character vector (ideally named) and calls
\code{ssvFetchBamPE.single} on each.  Appends grouping variable to each
resulting data.table and uses rbindlist to efficiently combine results
}
\details{
#' In contrast to ssvFetchBam, extension of reads to estimated fragment size is
not an issue as each read pair represents a fragment of exact size.

\code{ssvFetchBamPE} iteratively calls \code{fetchWindowedBam.single}. See
\code{\link{ssvFetchBamPE.single}} for more info.

if \code{qgr} contains the range chr1:1-100 and \code{win_size} is
10, values from positions chr1 5,15,25...85, and 95 will be retrieved from
\code{bw_file}
}
\examples{
if(Sys.info()['sysname'] != "Windows"){
library(GenomicRanges)
bam_f = system.file("extdata/Bcell_PE.mm10.bam",
    package = "seqsetvis", mustWork = TRUE)
bam_files = c("a" = bam_f, "b" = bam_f)
data("Bcell_peaks")
qgr = Bcell_peaks
bw_gr = ssvFetchBamPE(bam_files, qgr, win_size = 10)
bw_gr2 = ssvFetchBamPE(as.list(bam_files), qgr, win_size = 10)

bw_dt = ssvFetchBamPE(bam_files, qgr, win_size = 10,
    return_data.table = TRUE)
}
}
